package ch.frankel.blog.sitemesh;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * Filter that removes the SiteMesh request's attribute for error pages.
 * 
 * @author Nicolas Frankel
 */
public class SiteMeshBugfixFilter implements Filter {

	static final String FILTER_APPLIED = "com.opensymphony.sitemesh.APPLIED_ONCE";

	/**
	 * Does nothing.
	 */
	public void destroy() {
		// NOTHING TO DO
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		request.removeAttribute(FILTER_APPLIED);
		
		chain.doFilter(request, response);
	}

	/**
	 * Does nothing.
	 */
	public void init(FilterConfig config) throws ServletException {
		// NOTHING TO DO
	}
}
